# ENT Care Center - Laravel Website

A full-stack website for a medical clinic specializing in Ear, Nose, and Throat (ENT) care, built with Laravel framework.

## Features

- **Frontend Pages:**
  - Home page with hero section, services preview, doctor profiles, and testimonials
  - About Us page with clinic information, mission, vision, and doctor profiles
  - Services page with detailed service listings and individual service detail pages
  - Appointment booking form with email notifications
  - Contact page with Google Maps integration and contact form

- **Admin Panel:**
  - Secure authentication using Laravel Breeze
  - Dashboard with statistics and recent appointments
  - CRUD operations for managing doctors
  - CRUD operations for managing services
  - View and manage appointment requests
  - Update appointment statuses

- **Technical Features:**
  - Responsive design using Bootstrap 5
  - SEO-friendly structure with meta tags
  - Form validation and security
  - Email notifications for appointments and contact messages
  - Image upload for doctor profiles
  - Database migrations and seeders with dummy data

## Requirements

- PHP >= 8.2
- Composer
- MySQL or SQLite
- Node.js and NPM (for frontend assets)

## Installation

1. **Clone the repository or navigate to the project directory:**
   ```bash
   cd "ENT Care"
   ```

2. **Install PHP dependencies:**
   ```bash
   composer install
   ```

3. **Install NPM dependencies:**
   ```bash
   npm install
   ```

4. **Copy the environment file:**
   ```bash
   cp .env.example .env
   ```

5. **Generate application key:**
   ```bash
   php artisan key:generate
   ```

6. **Configure your database in `.env`:**
   ```env
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=ent_care
   DB_USERNAME=your_username
   DB_PASSWORD=your_password
   ```

   Or use SQLite (default):
   ```env
   DB_CONNECTION=sqlite
   ```

7. **Run migrations:**
   ```bash
   php artisan migrate
   ```

8. **Seed the database with dummy data:**
   ```bash
   php artisan db:seed
   ```

9. **Create storage link for images:**
   ```bash
   php artisan storage:link
   ```

10. **Build frontend assets:**
    ```bash
    npm run build
    ```

    Or for development:
    ```bash
    npm run dev
    ```

11. **Configure mail settings in `.env` (for email notifications):**
    ```env
    MAIL_MAILER=smtp
    MAIL_HOST=your_smtp_host
    MAIL_PORT=587
    MAIL_USERNAME=your_email
    MAIL_PASSWORD=your_password
    MAIL_ENCRYPTION=tls
    MAIL_FROM_ADDRESS=noreply@entcarecenter.com
    MAIL_FROM_NAME="${APP_NAME}"
    ```

## Default Admin Credentials

After seeding, you can log in with:
- **Email:** admin@entcarecenter.com
- **Password:** (Check the User factory or create a new user)

To create an admin user manually:
```bash
php artisan tinker
```
Then:
```php
User::create([
    'name' => 'Admin',
    'email' => 'admin@entcarecenter.com',
    'password' => Hash::make('password'),
]);
```

## Running the Application

1. **Start the development server:**
   ```bash
   php artisan serve
   ```

2. **Visit the application:**
   - Frontend: http://localhost:8000
   - Admin Panel: http://localhost:8000/admin/dashboard (requires login)

## Project Structure

```
ENT Care/
├── app/
│   ├── Http/Controllers/
│   │   ├── Admin/          # Admin controllers
│   │   └── ...             # Frontend controllers
│   └── Models/            # Eloquent models
├── database/
│   ├── migrations/        # Database migrations
│   └── seeders/           # Database seeders
├── resources/
│   └── views/
│       ├── admin/         # Admin panel views
│       ├── layouts/       # Layout templates
│       └── ...            # Frontend views
└── routes/
    └── web.php            # Application routes
```

## Key Routes

### Frontend:
- `/` - Home page
- `/about` - About Us page
- `/services` - Services listing
- `/services/{slug}` - Service detail page
- `/appointment` - Appointment booking
- `/contact` - Contact page

### Admin:
- `/admin/dashboard` - Admin dashboard
- `/admin/doctors` - Doctor management
- `/admin/services` - Service management
- `/admin/appointments` - Appointment management

## Features in Detail

### Appointment System
- Patients can book appointments with preferred doctors
- Email notifications sent to clinic
- Admin can view and update appointment statuses

### Doctor Management
- Add, edit, and delete doctors
- Upload doctor profile images
- Set doctor availability status

### Service Management
- Create and manage ENT services
- Add icons and descriptions
- Set service display order

## Security

- CSRF protection on all forms
- Input validation on all user inputs
- Authentication required for admin panel
- Secure file uploads for images

## License

This project is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).

## Support

For issues or questions, please contact the development team.
